/**********************************************************************************************
* Device      : AD18F08
* Author      : fengxuanmian
* Version     : V0.0.1
* Date        : 2023.5.4
* Description : 配置字中选择FINTOSC_DIV1(RC振荡器分频为1),通过PB4脚输出当前的系统时钟16M
*               FINTOSC_DIV共有五种可选分频可选
***********************************************************************************************/

#include "AD18F08.h"


/*********************************************************************************************
* 常用配置字功能说明：
*
* _FINTOSC_DIV1     :  内部时钟分频选择
* _DBG_OFF          :  禁用DEBUG模式（使能后DEBUG口不能做普通IO用）
* _LVREN_OFF         :  禁止使能
* _LVR24V           :  选择LVR电压为2.4V
* _FLASH_CP1_OFF    :  1K~2K*16 FLASH保护位
* _FLASH_CP0_OFF    :  0~1K*16 FLASH保护位
* _IDIS_OFF	     	:  模拟IO打开，数据读取控制位
* _CKSUM_OFF        :  使能程序校验
* _CBP_OFF			:  代码保护选择位
* _RESETE_OFF       :  禁用外部复位
* _RSEL				:  端口上下拉电阻选择
* _STV_ON		    :  堆栈溢出复位使能位
* _PSUT_2		    :  上电复位时间选择位
* _FCPU_4T          :  选择指令周期为4T模式
* _WDTE_OFF         :  看门狗使能位
* _TWDT_000         :  看门狗溢出时间选择位
* _OSCM_HIRC_16M    :  选择内部高速时钟16MHz
* _ADCSP_ON			:  ADC采集速度选择位
*
* 注意：1.配置字若无特别需求请勿修改；
*       2.其他配置字及相应功能见Datasheet及头文件；
*
************************************************************************************************/

__CONFIG(1,_FINTOSC_DIV1_1L     & _DBG_OFF_1L       & _LVREN_OFF_1L     & _LVR24V_1L                                                  );
__CONFIG(2,_FLASH_CP1_OFF_2L    & _FLASH_CP0_OFF_2L & _IDIS_OFF_2L     & _CKSUM_OFF_2L  & _CBP_OFF_2L   & _RESETE_OFF_2L & _RSEL_LOW_2L & _STV_ON_2L  );
__CONFIG(3,_PSUT_2_3L           & _FCPU_4T_3L       & _WDTE_OFF_3L    & _TWDT_100_3L                                                );
__CONFIG(4,_OSCM_HIRC_16M_4L    & _MTPDIS_OFF_4L    &_ADCSP_ON_4L                                                                                      );

//---------配置字 FINTOSC_DIV 可选--------------
//_FINTOSC_DIV1_1L        系统时钟1:1分频   16M (当选择内部高速时钟16M时)
//_FINTOSC_DIV2_1L        系统时钟1:2分频   8M  (当选择内部高速时钟16M时)
//_FINTOSC_DIV4_1L        系统时钟1:4分频   4M  (当选择内部高速时钟16M时)
//_FINTOSC_DIV8_1L        系统时钟1:8分频   2M  (当选择内部高速时钟16M时)
//_FINTOSC_DIV16_1L       系统时钟1:16分频  1M  (当选择内部高速时钟16M时)
//------------------------


void main(void)
{

	TRISB4 = 0;      //PB4设置为输出
    CKOE0 = 1;       //使能CKOE0 PB4口输出当前的系统时钟

}

//高优先级中断服务函数
void interrupt ISR_h (void)
{

}

//低优先级中断服务函数
void interrupt low_priority ISR_l (void)
{

}

